<?php
//---------------------------------------------------------------------------
// Network Traffic Monitor Log Analyzer
// Copyright by Vadim Churkin (C) 2010. All right reserved.
//---------------------------------------------------------------------------
define("APP_VERSION", "1.1");

$timexec = GetMicrotime();
$CONFIG = array();

$NLOGS = array();
$SLOGS = array();
$DEVICES = array();

$html_header = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">";
$html_header .= "<html>\r\n";
$html_header .= "<header>\r\n";
$html_header .= "<title>Network Traffic Monitor - </title>\r\n";
if(file_exists("main.css"))
        $html_header .= "<link rel='stylesheet' type='text/css' href='main.css' />\r\n";
$html_header .= "<style type='text/css'>\r\n";
$html_header .= "</style>\r\n";
$html_header .= "</header>\r\n";
$html_header .= "<body>\r\n";
$html_header .= "\r\n";

$html = "\r\n";
$html .= "<h1>Network Traffic Monitor Log Analyzer</h1>\r\n";
$html .= "<!-- CURRENT VERSION: ".APP_VERSION." -->\r\n";

$html .= "<h2></h2>\r\n";

$html .= "<div id='menu' style='border-bottom: 1px solid #4080F0;'>\r\n";   //
$html .= "<ul>\r\n";
$html .= "<li".(($_REQUEST["by"] == "days")? " id='current'" : "")."><a href='?by=days'>  </a></li>\r\n";
$html .= "<li".(($_REQUEST["by"] == "weeks")? " id='current'" : "")."><a href='?by=weeks'>  </a></li>\r\n";
$html .= "<li".(($_REQUEST["by"] == "months")? " id='current'" : "")."><a href='?by=months'>  </a></li>\r\n";
$html .= "<li".(($_REQUEST["by"] == "hours")? " id='current'" : "")."><a href='?by=hours'> </a></li>\r\n";
$html .= "</ul>\r\n";
$html .= "</div>\r\n";

$html .= "<div style='clear: both; padding-top: 20px;'>\r\n";
if(file_exists("config.php"))
{
  @include("config.php");

  if(isset($_REQUEST["do"]) && ($_REQUEST["do"] == "config"))
  {
  	$html .= Install();
  }
  else
  {
    ParseLog($CONFIG["log_file"]);

    if($_REQUEST["by"] == "days")
    	$html .= ShowLog_ByDays(30);
    else if($_REQUEST["by"] == "weeks")
    	$html .= ShowLog_ByWeeks(16);
    else if($_REQUEST["by"] == "months")
    	$html .= ShowLog_ByMonths(12);
    else if($_REQUEST["by"] == "hours")
    	$html .= ShowLog_ByHours(24);
    else
    {
      $html .= "<h3></h3>\r\n";
      $html .= "<p> PHP        <b>Network Traffic Monitor</b>    .</p>\r\n";
      $html .= "<p>    PHP    4.3    <b>GD</b>  <b>iconv</b>.</p>\r\n";
      $html .= "<p>        ,        . ";
      $html .= " ,         <b>config.php</b>,        , ";
      $html .= "         <b>images</b>,       . ";
      $html .= "           .</p>\r\n";
    }
  }
}
else
{
	$html .= Install();
}
$html .= "</div>\r\n";

$html .= "<div style='clear: both;'>\r\n";
$html .= "<hr />\r\n";
$html .= "<div style='text-align: right;'>\r\n";
$html .= "<a href='?do=q&by=days' id='applinksitem'>  </a>\r\n";
$html .= "<span class='applinksitem' style='padding-left: 5px; padding-right: 5px;'>|</span>\r\n";
$html .= "<a href='?do=q&by=weeks' id='applinksitem'>  </a>\r\n";
$html .= "<span class='applinksitem' style='padding-left: 5px; padding-right: 5px;'>|</span>\r\n";
$html .= "<a href='?do=q&by=months' id='applinksitem'>  </a>\r\n";
$html .= "<span class='applinksitem' style='padding-left: 5px; padding-right: 5px;'>|</span>\r\n";
$html .= "<a href='?do=q&by=hours' id='applinksitem'> </a>\r\n";
$html .= "<span class='applinksitem' style='padding-left: 5px; padding-right: 5px;'>|</span>\r\n";
$html .= "<a href='?do=config' id='applinksitem'></a>\r\n";
$html .= "</div>\r\n";
$html .= "<div style='text-align: center; padding: 10px; color: #808080; font-weight: bold; font-size: 0.8em'>".sprintf("%.2f mks", GetMicrotime($timexec)*1000)."</div>\r\n";
$html .= "<div class='copyright'>Copyright by Vadim Churkin &copy; 2010. All right reserved.</div>\r\n";
$html .= "</div>\r\n";

$html_footer = "</body>\r\n";
$html_footer .= "</html>\r\n";
$html_footer .= "\r\n";

header("Cache-Control: no-cache, must-revalidate");
header("Expires: Sun, 26 Jul 1970 11:30:00 GMT");
echo $html_header;
echo $html;
echo $html_footer;
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
function Install()
{
  global $CONFIG;

  $html = "";
  if(isset($_REQUEST["lf"]) && file_exists($_REQUEST["lf"]))
  {
  	if($hf = fopen("config.php", "w+"))
  	{
      $CFG = array();
      array_push($CFG, "<?php");
      array_push($CFG, "//     Network Traffic Monitor");
      array_push($CFG, "\$CONFIG[\"log_file\"] = \"".$_REQUEST["lf"]."\";");
      array_push($CFG, "//     ( 1 -  / 0 -  )");
      array_push($CFG, "\$CONFIG[\"show_datagram\"] = ".((isset($_REQUEST["sd"]))? 1 : 0).";");
      array_push($CFG, "?>");
      fwrite($hf, implode("\r\n", $CFG));
      fclose($hf);

      header("Location: ?do=");
  	}
  }

  $html .= "<h3></h3>\r\n";
  $html .= "<table width='100%' border='0' cellspacing='0' cellpadding='5'><tr><td style='border: 1px solid #4080F0; background: #C0F0C0;'>\r\n";

  if(isset($_REQUEST["lf"]))
  {
    $html .= "<div class='error' style='margin-bottom: 5px;'>\r\n";
    $html .= " <span class='errorstrong'>".htmlspecialchars(stripslashes($_REQUEST["lf"]))."</span>  .\r\n";
    $html .= "</div>\r\n";
  }

  $html .= "<form name='config' action='?do=config' method='post'>\r\n";
  $html .= "<table border='0' cellspacing='0' cellpadding='5'><tr><td style='border: 1px solid #4080F0; background: #F0F0C0;'>\r\n";
  $html .= "<table border='0' cellspacing='0' cellpadding='2'>\r\n";
  $html .= "<tr><td>   :</td><td><input name='lf' type='edit' value='".$CONFIG["log_file"]."' size='60' /></td></tr>\r\n";
  $html .= "<tr><td>   :</td><td><input name='sd' type='checkbox' ".(($CONFIG["show_datagram"])? "checked" : "")." /></td></tr>\r\n";
  $html .= "<tr><td colspan='2' style='padding-top: 10px; text-align: right;'><input type='button' value='' onfocus='this.blur()' onclick='document.forms.config.submit()'></td></tr>\r\n";
  $html .= "</table>\r\n";
  $html .= "</td></tr></table>\r\n";
  $html .= "</form>\r\n";

  $html .= "</td></tr></table>\r\n";

  return($html);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
function ParseLog($fname)
{
  global $NLOGS, $SLOGS, $DEVICES;

  $NLOGS = array();
  $SLOGS = array();
  $DEVICES = array();

  if(!file_exists($fname))
          return;

  $LOGS = file($fname);

  $data_in = 0;
  $data_out = 0;
  $datetime = 0;
  $DDEV = array();
  foreach($LOGS as $msg)
  {
    if(preg_match("#^\[([SNEW])\](\s*)-(\s*)\[(\d+):(\d+):(\d+)(\s*)-(\s*)(\d+)/(\d+)/(\d+)\](\s*)-(\s*)(.*)$#", trim($msg), $R))
    {
    	$dt = mktime($R[4], $R[5], $R[6], $R[10], $R[11], $R[9]);
      if($R[1] == "N")
      {
        if(preg_match("#^(?i)MAC:(\s*)(.+)-(.+)-(.+)-(.+)-(.+)-(.+);(\s*)SpeedIn:(\s*)(.+);(\s*)SpeedOut:(\s*)(.+);(\s*)InOctets:(\s*)(\d+);(\s*)OutOctets:(\s*)(\d+);(.*)$#", trim($R[14]), $RR))
        {
          $dev = GetDeviceID($RR[2]."-".$RR[3]."-".$RR[4]."-".$RR[5]."-".$RR[6]."-".$RR[7], $DEVICES);
          if(isset($DDEV[$dev]))
          {
          	$data_in = $DDEV[$dev]["data_in"];
          	$data_out = $DDEV[$dev]["data_out"];
          	$datetime = $DDEV[$dev]["datetime"];
          }
          else
          {
          	$data_in = 0;
          	$data_out = 0;
          	$datetime = 0;
          }
          array_push($NLOGS, array(
          	"datetime" => $dt,
          	"device" => $dev,
          	"speed_in" => $RR[10],
          	"speed_out" => $RR[13],
          	"data_in" => ($RR[16] > $data_in)? $RR[16] - $data_in : $RR[16],
          	"data_out" => ($RR[19] > $data_out)? $RR[19] - $data_out : $RR[19],
          	"interval" => $dt - $datetime
          ));
					$DDEV[$dev] = array(
          	"data_in" => $RR[16],
          	"data_out" => $RR[19],
          	"datetime" => $dt
          );
          //echo $RR[2]."-".$RR[3]."-".$RR[4]."-".$RR[5]."-".$RR[6]."-".$RR[7]."; ".$RR[10]."; ".$RR[13]."; ".$RR[16]."; ".$RR[19]."; [OK]"."<br>\r\n";
        }
      }
      else if($R[1] == "S")
      {
      	//echo $R[1]." - ".$R[4].":".$R[5].":".$R[6]."-".$R[9]."/".$R[10]."/".$R[11]." - ".$R[14]."<br>\r\n";
      	if(preg_match("#^(?i)Start listen NET: (.*); MAC:(\s*)(.+)-(.+)-(.+)-(.+)-(.+)-(.+).(.*)$#", trim($R[14]), $RR))
      	{
      		$dev = GetDeviceID($RR[3]."-".$RR[4]."-".$RR[5]."-".$RR[6]."-".$RR[7]."-".$RR[8], $DEVICES);
    			$DDEV[$dev] = array(
     				"data_in" => 0,
     				"data_out" => 0,
     				"datetime" => $dt
     			);
      	}
      }
    }
  }
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
function ShowLog_ByHours($hours)
{
  global $NLOGS, $SLOGS, $DEVICES, $CONFIG;

  $html = "";

  $DATE = localtime(time(), true);
  $DATE["tm_year"] += 1900;
  $DATE["tm_mon"] += 1;

  $RESULT = array();
  for($i = 0; $i < $hours; $i++)
  {
    $mintime = mktime($DATE["tm_hour"]+$i-$hours+1, 0, 0, $DATE["tm_mon"], $DATE["tm_mday"], $DATE["tm_year"]);
    $maxtime = mktime($DATE["tm_hour"]+$i-$hours+2, 0, 0, $DATE["tm_mon"], $DATE["tm_mday"], $DATE["tm_year"]);

    $RES = array();
    foreach($NLOGS as $NL)
    {
      if(($NL["datetime"] >= $mintime) && ($NL["datetime"] < $maxtime))
      {
        if(!isset($RES[$NL["device"]]))
        {
          $RES[$NL["device"]] = array(
            "data_in" => 0,
            "data_out" => 0,
            "interval" => $maxtime-$mintime
          );
        }
        $RES[$NL["device"]]["data_in"] += $NL["data_in"];
        $RES[$NL["device"]]["data_out"] += $NL["data_out"];
      }
    }
    $RESULT[$mintime] = $RES;
  }
  ksort($RESULT);

  $html .= "<h3> </h3>\r\n";
  $html .= "<table width='100%' cellspacing='0' border='0' cellpadding='5'><tr><td style='border: 1px solid black; background: #C0F0C0;'>\r\n";
  $html .= "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\r\n";

  $html .= "<tr>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'>MAC</td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'> </td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'> </td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "</tr>\r\n";

  $index = 0;
  $data_in_all = 0;
  $data_out_all = 0;
  $data_max = 0;
  $hoursize = 3599; // 60*60-1
  foreach($RESULT as $date => $RES)
  {
    $clr_bg = ($index % 2)? "#F0F0F0" : "#E0E0F0";

    $html_row = "";
    $data_dall = 0;
    foreach($RES as $device => $DATA)
    {
      $data_in = $DATA["data_in"];
      $data_out = $DATA["data_out"];
      $data_all = $data_in + $data_out;
      $data_dall += $data_all;
      $data_in_all += $data_in;
      $data_out_all += $data_out;
      $html_row .= "<tr>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".date("d/m/Y", $date)."</td>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".date("H:i", $date)." - ".date("H:i", $date+$hoursize)."</td>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".$DEVICES[$device]."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed($data_in, $DATA["interval"])."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed($data_out, $DATA["interval"])."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_in)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_out)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_all)."</td>";
      $html_row .= "</tr>\r\n";
    }

    if($data_dall > $data_max)
    	$data_max = $data_dall;

    if(strlen($html_row) == 0)
    {
      $html_row .= "<tr>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".date("d/m/Y", $date)."</td>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".date("H:i", $date)." - ".date("H:i", $date+$hoursize)."</td>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'> - </td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed(0, 1)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed(0, 1)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize(0)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize(0)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize(0)."</td>";
      $html_row .= "</tr>\r\n";
    }

    $html .= $html_row;

    $index++;
  }

  $clr_bg = "#F0E0E0";
  $html .= "<tr>\r\n";
  $html .= "<td colspan='5' style='text-align: right; padding-left: 10px; padding-right: 10px; font-weight: bold;'>:</td>\r\n";
  $html .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_in_all)."</td>";
  $html .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_out_all)."</td>";
  $html .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_in_all + $data_out_all)."</td>";
  $html .= "</tr>\r\n";

  $html .= "</table>\r\n";

  if($CONFIG["show_datagram"])
  	$html .= ShowDatagram($RESULT, $data_max, "       .", "%H:%M", 800, 100);

  $html .= "</td></tr></table>\r\n";

  return($html);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
function ShowLog_ByMonths($months)
{
  global $NLOGS, $SLOGS, $DEVICES, $CONFIG;

  $html = "";

  $DATE = localtime(time(), true);
  $DATE["tm_year"] += 1900;
  $DATE["tm_mon"] += 2;
  $DATE["tm_mday"] = 1;

  $RESULT = array();
  for($i = 0; $i < $months; $i++)
  {
    $mintime = mktime(0, 0, 0, $DATE["tm_mon"]+$i-$months, $DATE["tm_mday"], $DATE["tm_year"]);
    $maxtime = mktime(0, 0, 0, $DATE["tm_mon"]+$i-$months+1, $DATE["tm_mday"], $DATE["tm_year"]);

    $RES = array();
    foreach($NLOGS as $NL)
    {
      if(($NL["datetime"] >= $mintime) && ($NL["datetime"] < $maxtime))
      {
        if(!isset($RES[$NL["device"]]))
        {
        	$RES[$NL["device"]] = array(
         		"data_in" => 0,
      			"data_out" => 0,
        		"interval" => $maxtime - $mintime
          );
        }
        $RES[$NL["device"]]["data_in"] += $NL["data_in"];
        $RES[$NL["device"]]["data_out"] += $NL["data_out"];
      }
    }
    $RESULT[$mintime] = $RES;
	}
  ksort($RESULT);

  $html .= "<h3>  </h3>\r\n";
  $html .= "<table width='100%' cellspacing='0' border='0' cellpadding='5'><tr><td style='border: 1px solid black; background: #C0F0C0;'>\r\n";
  $html .= "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\r\n";

  $html .= "<tr>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'>MAC</td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'> </td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'> </td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "</tr>\r\n";

  $index = 0;
  $data_in_all = 0;
  $data_out_all = 0;
  $data_max = 0;
  setlocale(LC_ALL, "ru");
  foreach($RESULT as $date => $RES)
  {
    $clr_bg = ($index % 2)? "#F0F0F0" : "#E0E0F0";

    $html_row = "";
    $data_dall = 0;
    foreach($RES as $device => $DATA)
    {
      $data_in = $DATA["data_in"];
      $data_out = $DATA["data_out"];
      $data_all = $data_in + $data_out;
      $data_dall += $data_all;
      $data_in_all += $data_in;
      $data_out_all += $data_out;
      $html_row .= "<tr>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".strftime("%B, %Y", $date)."</td>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".$DEVICES[$device]."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed($data_in, $DATA["interval"])."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed($data_out, $DATA["interval"])."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_in)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_out)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_all)."</td>";
      $html_row .= "</tr>\r\n";
    }

    if($data_dall > $data_max)
    	$data_max = $data_dall;

    if(strlen($html_row) == 0)
    {
      $html_row .= "<tr>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".strftime("%B, %Y", $date)."</td>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'> - </td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed(0, 1)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed(0, 1)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize(0)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize(0)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize(0)."</td>";
      $html_row .= "</tr>\r\n";
    }

    $html .= $html_row;

    $index++;
  }

  $clr_bg = "#F0E0E0";
  $html .= "<tr>\r\n";
  $html .= "<td colspan='4' style='text-align: right; padding-left: 10px; padding-right: 10px; font-weight: bold;'>:</td>\r\n";
  $html .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_in_all)."</td>";
  $html .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_out_all)."</td>";
  $html .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_in_all + $data_out_all)."</td>";
  $html .= "</tr>\r\n";

  $html .= "</table>\r\n";

  if($CONFIG["show_datagram"])
  	$html .= ShowDatagram($RESULT, $data_max, "       .", "%B %Y", 800, 100);

  $html .= "</td></tr></table>\r\n";

  return($html);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
function ShowLog_ByWeeks($weeks)
{
  global $NLOGS, $SLOGS, $DEVICES, $CONFIG;

  $html = "";

  $DATE = localtime(time(), true);
  $DATE["tm_year"] += 1900;
  $DATE["tm_mon"] += 1;
  $DATE["tm_mday"] += 8 - $DATE["tm_wday"];

  $RESULT = array();
//$wdays = $weeks * 7;
  for($i = 0; $i < $weeks; $i++)
  {
    $mintime = mktime(0, 0, 0, $DATE["tm_mon"], $DATE["tm_mday"]+($i-$weeks)*7, $DATE["tm_year"]);
    $maxtime = mktime(0, 0, 0, $DATE["tm_mon"], $DATE["tm_mday"]+($i-$weeks+1)*7, $DATE["tm_year"]);

    $RES = array();
    foreach($NLOGS as $NL)
    {
      if(($NL["datetime"] >= $mintime) && ($NL["datetime"] < $maxtime))
      {
        if(!isset($RES[$NL["device"]]))
        {
        	$RES[$NL["device"]] = array(
         		"data_in" => 0,
           	"data_out" => 0,
        		"interval" => $maxtime - $mintime
        	);
        }
        $RES[$NL["device"]]["data_in"] += $NL["data_in"];
        $RES[$NL["device"]]["data_out"] += $NL["data_out"];
      }
    }
    $RESULT[$mintime] = $RES;
  }
  ksort($RESULT);

  $html .= "<h3>  </h3>\r\n";
  $html .= "<table width='100%' cellspacing='0' border='0' cellpadding='5'><tr><td style='border: 1px solid black; background: #C0F0C0;'>\r\n";
  $html .= "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\r\n";

  $html .= "<tr>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'>MAC</td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'> </td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'> </td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "</tr>\r\n";

  $index = 0;
  $data_in_all = 0;
  $data_out_all = 0;
  $data_max = 0;
  $weeksize = 604799; //7*24*60*60-1;
  foreach($RESULT as $date => $RES)
  {
    $clr_bg = ($index % 2)? "#F0F0F0" : "#E0E0F0";

    $html_row = "";
    $data_dall = 0;
    foreach($RES as $device => $DATA)
    {
      $data_in = $DATA["data_in"];
      $data_out = $DATA["data_out"];
      $data_all = $data_in + $data_out;
      $data_dall += $data_all;
      $data_in_all += $data_in;
      $data_out_all += $data_out;
      $html_row .= "<tr>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".date("d/m/Y", $date)." - ".date("d/m/Y", $date+$weeksize)."</td>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".$DEVICES[$device]."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed($data_in, $DATA["interval"])."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed($data_out, $DATA["interval"])."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_in)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_out)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_all)."</td>";
      $html_row .= "</tr>\r\n";
    }

    if($data_dall > $data_max)
    	$data_max = $data_dall;

    if(strlen($html_row) == 0)
    {
      $html_row .= "<tr>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".date("d/m/Y", $date)." - ".date("d/m/Y", $date+$weeksize)."</td>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'> - </td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed(0, 1)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed(0, 1)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize(0)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize(0)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize(0)."</td>";
      $html_row .= "</tr>\r\n";
    }

    $html .= $html_row;

    $index++;
  }

  $clr_bg = "#F0E0E0";
  $html .= "<tr>\r\n";
  $html .= "<td colspan='4' style='text-align: right; padding-left: 10px; padding-right: 10px; font-weight: bold;'>:</td>\r\n";
  $html .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_in_all)."</td>";
  $html .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_out_all)."</td>";
  $html .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_in_all + $data_out_all)."</td>";
  $html .= "</tr>\r\n";

  $html .= "</table>\r\n";

  if($CONFIG["show_datagram"])
  	$html .= ShowDatagram($RESULT, $data_max, "       .", "%d %b", 800, 100);

  $html .= "</td></tr></table>\r\n";

  return($html);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
function ShowLog_ByDays($days)
{
  global $NLOGS, $SLOGS, $DEVICES, $CONFIG;

  $DATE = localtime(time(), true);
  $DATE["tm_year"] += 1900;
  $DATE["tm_mon"] += 1;

  $RESULT = array();
  for($i = 0; $i < $days; $i++)
  {
    $mintime = mktime(0, 0, 0, $DATE["tm_mon"], $DATE["tm_mday"]-$days+$i+1, $DATE["tm_year"]);
    $maxtime = mktime(0, 0, 0, $DATE["tm_mon"], $DATE["tm_mday"]-$days+$i+2, $DATE["tm_year"]);

    $RES = array();
    foreach($NLOGS as $NL)
    {
      if(($NL["datetime"] >= $mintime) && ($NL["datetime"] < $maxtime))
      {
      if(!isset($RES[$NL["device"]]))
      {
      	$RES[$NL["device"]] = array(
       		"data_in" => 0,
         	"data_out" => 0,
      		"interval" => $maxtime - $mintime
      	);
      }
      $RES[$NL["device"]]["data_in"] += $NL["data_in"];
      $RES[$NL["device"]]["data_out"] += $NL["data_out"];
      }
    }
    $RESULT[$mintime] = $RES;
  }

  ksort($RESULT);

  $html .= "<h3>  </h3>\r\n";
  $html .= "<table width='100%' cellspacing='0' border='0' cellpadding='5'><tr><td style='border: 1px solid black; background: #C0F0C0;'>\r\n";
  $html .= "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\r\n";

  $html .= "<tr>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'>MAC</td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'> </td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'> </td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "<td style='font-weight: bold; border: 1px solid #C0C0C0; background: #404080; color: #FFFFFF; text-align: center;'></td>";
  $html .= "</tr>\r\n";

  $index = 0;
  $data_in_all = 0;
  $data_out_all = 0;
  $data_max = 0;
  foreach($RESULT as $date => $RES)
  {
  	$clr_bg = ($index % 2)? "#F0F0F0" : "#E0E0F0";

   	$html_row = "";
    $data_dall = 0;
    foreach($RES as $device => $DATA)
    {
    	$data_in = $DATA["data_in"];
      $data_out = $DATA["data_out"];
      $data_all = $data_in + $data_out;
      $data_in_all += $data_in;
      $data_out_all += $data_out;
      $data_dall += $data_all;
      $html_row .= "<tr>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".date("d/m/Y", $date)."</td>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".$DEVICES[$device]."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed($data_in, $DATA["interval"])."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed($data_out, $DATA["interval"])."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_in)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_out)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_all)."</td>";
      $html_row .= "</tr>\r\n";
    }

    if($data_dall > $data_max)
     	$data_max = $data_dall;

		if(strlen($html_row) == 0)
    {
    	$html_row .= "<tr>\r\n";
     	$html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".date("d/m/Y", $date)."</td>\r\n";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'> - </td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed(0, 1)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSpeed(0, 1)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize(0)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize(0)."</td>";
      $html_row .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize(0)."</td>";
      $html_row .= "</tr>\r\n";
		}

		$html .= $html_row;

  	$index++;
  }

  $clr_bg = "#F0E0E0";
  $html .= "<tr>\r\n";
  $html .= "<td colspan='4' style='text-align: right; padding-left: 10px; padding-right: 10px; font-weight: bold;'>:</td>\r\n";
  $html .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_in_all)."</td>";
  $html .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_out_all)."</td>";
  $html .= "<td style='text-align: center; padding-left: 10px; padding-right: 10px; border: 1px solid #C0C0C0; background: ".$clr_bg.";'>".GenDataSize($data_in_all + $data_out_all)."</td>";
  $html .= "</tr>\r\n";

  $html .= "</table>\r\n";

  if($CONFIG["show_datagram"])
  	$html .= ShowDatagram($RESULT, $data_max, "       .", "%d %b", 800, 100);

  $html .= "</td></tr></table>\r\n";

  return($html);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
function ShowDatagram($RESULT, $data_max, $title, $format, $img_w, $img_h)
{
  $html = "";

  $IMG_CLR = array();
  $IMG_CFG = array();
  $IMG_CFG["size"] = array("width" => 0, "height" => 0);
  $IMG_CFG["axis"] = array(
  	"origin" => array("x" => 0, "y" => 0),
   	"size" => array("horz" => 0, "vert" => 0)
  );
  $IMG_CFG["font"] = array(
  	"name" => "arialn.ttf",
   	"size" => 6
  );
  $IMG_CFG["data"] = array(
  	"format" => $format,
   	"title" => $title
  );

  if(!file_exists($IMG_CFG["font"]["name"]))
  	return("");

  $IMG_CFG["size"]["width"] = $img_w;
  $IMG_CFG["size"]["height"] = $img_h;
  $IMG_CFG["axis"]["origin"]["x"] = 5;
  $IMG_CFG["axis"]["origin"]["y"] = $IMG_CFG["size"]["height"] - 30;
  $IMG_CFG["axis"]["size"]["horz"] = $IMG_CFG["size"]["width"] - $IMG_CFG["axis"]["origin"]["x"] - 5;
  $IMG_CFG["axis"]["size"]["vert"] = $IMG_CFG["axis"]["origin"]["y"] - 5;

  $img = imagecreatetruecolor($IMG_CFG["size"]["width"], $IMG_CFG["size"]["height"]);
  $IMG_CLR["bg"] = imagecolorallocate($img, 255, 255, 255);
  $IMG_CLR["axis"] = imagecolorallocate($img, 80, 80, 80);
  $IMG_CLR["grid"] = imagecolorallocate($img, 0xC0, 0xC0, 0xC0);
  $IMG_CLR["in"] = imagecolorallocate($img, 0xF0, 0x00, 0x00);
  $IMG_CLR["out"] = imagecolorallocate($img, 0x40, 0x40, 0xC0);
  $IMG_STYLE = array("dashed" => array());
  $IMG_STYLE["dashed"] = array($IMG_CLR["grid"],$IMG_CLR["grid"],$IMG_CLR["grid"],$IMG_CLR["bg"],$IMG_CLR["bg"],$IMG_CLR["bg"]);

  imagefill($img, 0, 0, $IMG_CLR["bg"]);

  $str = iconv("windows-1251", "utf-8", GenDataSize($data_max));
  $BBOX = imagettfbbox($IMG_CFG["font"]["size"], 0, $IMG_CFG["font"]["name"], $str);
  $w = $BBOX[2] - $BBOX[0] + 8;
  $IMG_CFG["axis"]["origin"]["x"] += $w;
  $IMG_CFG["axis"]["size"]["horz"] -= $w;
  $y = $IMG_CFG["axis"]["origin"]["y"] - $IMG_CFG["axis"]["size"]["vert"] + 5;
  imagettftext($img, $IMG_CFG["font"]["size"], 0, $IMG_CFG["axis"]["origin"]["x"] - ($BBOX[2] - $BBOX[0]) - 4, $y + ($BBOX[1] - $BBOX[7]) / 2, $IMG_CLR["axis"], $IMG_CFG["font"]["name"], $str);
  imagesetstyle($img, $IMG_STYLE["dashed"]);
  imageline($img, $IMG_CFG["axis"]["origin"]["x"], $y, $IMG_CFG["axis"]["origin"]["x"] + $IMG_CFG["axis"]["size"]["horz"], $y, IMG_COLOR_STYLED);

  $str = iconv("windows-1251", "utf-8", GenDataSize($data_max / 3 * 2));
  $BBOX = imagettfbbox($IMG_CFG["font"]["size"], 0, $IMG_CFG["font"]["name"], $str);
  $y = $IMG_CFG["axis"]["origin"]["y"] - ($IMG_CFG["axis"]["size"]["vert"] - 5) * 2 / 3;
  imagettftext($img, $IMG_CFG["font"]["size"], 0, $IMG_CFG["axis"]["origin"]["x"] - ($BBOX[2] - $BBOX[0]) - 4, $y + ($BBOX[1] - $BBOX[7]) / 2, $IMG_CLR["axis"], $IMG_CFG["font"]["name"], $str);
  imagesetstyle($img, $IMG_STYLE["dashed"]);
  imageline($img, $IMG_CFG["axis"]["origin"]["x"], $y, $IMG_CFG["axis"]["origin"]["x"] + $IMG_CFG["axis"]["size"]["horz"], $y, IMG_COLOR_STYLED);

  $str = iconv("windows-1251", "utf-8", GenDataSize($data_max / 3));
  $BBOX = imagettfbbox($IMG_CFG["font"]["size"], 0, $IMG_CFG["font"]["name"], $str);
  $y = $IMG_CFG["axis"]["origin"]["y"] - ($IMG_CFG["axis"]["size"]["vert"] - 5) / 3;
  imagettftext($img, $IMG_CFG["font"]["size"], 0, $IMG_CFG["axis"]["origin"]["x"] - ($BBOX[2] - $BBOX[0]) - 4, $y + ($BBOX[1] - $BBOX[7]) / 2, $IMG_CLR["axis"], $IMG_CFG["font"]["name"], $str);
  imagesetstyle($img, $IMG_STYLE["dashed"]);
  imageline($img, $IMG_CFG["axis"]["origin"]["x"], $y, $IMG_CFG["axis"]["origin"]["x"] + $IMG_CFG["axis"]["size"]["horz"], $y, IMG_COLOR_STYLED);

  $str = iconv("windows-1251", "utf-8", "0 ");
  $BBOX = imagettfbbox($IMG_CFG["font"]["size"], 0, $IMG_CFG["font"]["name"], $str);
  imagettftext($img, $IMG_CFG["font"]["size"], 0, $IMG_CFG["axis"]["origin"]["x"] - ($BBOX[2] - $BBOX[0]) - 4, $IMG_CFG["axis"]["origin"]["y"] + ($BBOX[1] - $BBOX[7]) / 2, $IMG_CLR["axis"], $IMG_CFG["font"]["name"], $str);

  $step = $IMG_CFG["axis"]["size"]["horz"] / count($RESULT);
  $x = $IMG_CFG["axis"]["origin"]["x"] + $step / 2;
  $wbox = $step * 3 / 8;
  setlocale(LC_ALL, "ru");
  foreach($RESULT as $date => $RES)
  {
    $str = iconv("windows-1251", "utf-8", strftime($IMG_CFG["data"]["format"], $date));
    $BBOX = imagettfbbox($IMG_CFG["font"]["size"], 0, $IMG_CFG["font"]["name"], $str);
    imagettftext($img, $IMG_CFG["font"]["size"], 0, $x - ($BBOX[2] - $BBOX[0]) / 2, $IMG_CFG["axis"]["origin"]["y"] + 6 + ($BBOX[1] - $BBOX[7]) / 2, $IMG_CLR["axis"], $IMG_CFG["font"]["name"], $str);
    imagesetstyle($img, $IMG_STYLE["dashed"]);
    imageline($img, $x, $IMG_CFG["axis"]["origin"]["y"], $x, $IMG_CFG["axis"]["origin"]["y"] - $IMG_CFG["axis"]["size"]["vert"], IMG_COLOR_STYLED);
    $data_in = 0;
    $data_out = 0;
    foreach($RES as $device => $DATA)
    {
      $data_in += $DATA["data_in"] - $DATA["offset_data_in"];
      $data_out += $DATA["data_out"] - $DATA["offset_data_out"];
    }
    $data_all = $data_in + $data_out;
    $h_max = ($data_max > 0)? ($IMG_CFG["axis"]["size"]["vert"] - 5) * ($data_all / $data_max) : 0;
    $h_in = ($data_all > 0)? $h_max * ($data_in / $data_all) : 0;
    $h_out = $h_max - $h_in;
    if($h_max > 0)
    {
      imagerectangle($img, $x - $wbox-1, $IMG_CFG["axis"]["origin"]["y"], $x + $wbox+1, $IMG_CFG["axis"]["origin"]["y"] - $h_max, $IMG_CLR["axis"]);
      imagefilledrectangle($img, $x - $wbox, $IMG_CFG["axis"]["origin"]["y"], $x + $wbox, $IMG_CFG["axis"]["origin"]["y"] - $h_in, $IMG_CLR["in"]);
      imagefilledrectangle($img, $x - $wbox, $IMG_CFG["axis"]["origin"]["y"] - $h_in, $x + $wbox, $IMG_CFG["axis"]["origin"]["y"] - $h_max, $IMG_CLR["out"]);
    }
    $x += $step;
  }

  imageline($img, $IMG_CFG["axis"]["origin"]["x"], $IMG_CFG["axis"]["origin"]["y"], $IMG_CFG["axis"]["origin"]["x"] + $IMG_CFG["axis"]["size"]["horz"], $IMG_CFG["axis"]["origin"]["y"], $IMG_CLR["axis"]);
  imageline($img, $IMG_CFG["axis"]["origin"]["x"], $IMG_CFG["axis"]["origin"]["y"] - $IMG_CFG["axis"]["size"]["vert"], $IMG_CFG["axis"]["origin"]["x"], $IMG_CFG["axis"]["origin"]["y"], $IMG_CLR["axis"]);

  $x = $IMG_CFG["axis"]["origin"]["x"];
  $y = $IMG_CFG["axis"]["origin"]["y"] + 20;
  $wbox = 10;
  $hbox = 1;
  $str = iconv("windows-1251", "utf-8", " ;");
  $BBOX = imagettfbbox($IMG_CFG["font"]["size"], 0, $IMG_CFG["font"]["name"], $str);
  imagefilledrectangle($img, $x, $y - $hbox, $x + $wbox, $y + $hbox, $IMG_CLR["out"]);
  imagerectangle($img, $x, $y - $hbox, $x + $wbox, $y + $hbox, $IMG_CLR["axis"]);
  $x += $wbox+8;
  imagettftext($img, $IMG_CFG["font"]["size"], 0, $x, $y + ($BBOX[1] - $BBOX[7]) / 2, $IMG_CLR["axis"], $IMG_CFG["font"]["name"], $str);
  $x += ($BBOX[2] - $BBOX[0]) + 10;
  $str = iconv("windows-1251", "utf-8", " ;");
  $BBOX = imagettfbbox($IMG_CFG["font"]["size"], 0, $IMG_CFG["font"]["name"], $str);
  imagefilledrectangle($img, $x, $y - $hbox, $x + $wbox, $y + $hbox, $IMG_CLR["in"]);
  imagerectangle($img, $x, $y - $hbox, $x + $wbox, $y + $hbox, $IMG_CLR["axis"]);
  $x += $wbox+8;
  imagettftext($img, $IMG_CFG["font"]["size"], 0, $x, $y + ($BBOX[1] - $BBOX[7]) / 2, $IMG_CLR["axis"], $IMG_CFG["font"]["name"], $str);

  if(imagepng($img, "images/log.png"))
  {
    $html .= "<div style='margin-top: 30px; margin-bottom: 20px; text-align: center;'>\r\n";
    $html .= "<div style='font-size: 0.7em; font-weight: bold;'>".$IMG_CFG["data"]["title"]."</div>\r\n";
    $html .= "<img src='images/log.png?t=".md5(microtime())."' align='center' alt='".$IMG_CFG["data"]["title"]."' title='".$IMG_CFG["data"]["title"]."'>\r\n";
    $html .= "</div>\r\n";
  }

  return($html);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
function GetDeviceID($mac, &$DL)
{
  $id = 0;
  foreach($DL as $mmac)
  {
    if($mmac == $mac)
    	return($id);
    $id++;
  }
  array_push($DL, $mac);
  return($id);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
function GenDataSize($data)
{
  if($data < 1000)
  	return($data." ");
  else if($data < 1000000)
  	return(sprintf("%.2f ", $data / 1000));
  else if($data < 1000000000)
  	return(sprintf("%.2f ", $data / 1000000));
  else
  	return(sprintf("%.2f ", $data / 1000000000));
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
function GenDataSpeed($data, $interval)
{
  $data = ($interval > 0)? $data / $interval : 0;
  if($data < 1000)
  	return(sprintf("%.2f /c", $data));
  else if($data < 1000000)
  	return(sprintf("%.2f /c", $data / 1000));
  else if($data < 1000000000)
  	return(sprintf("%.2f /c", $data / 1000000));
  else
  	return(sprintf("%.2f /c", $data / 1000000000));
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
function GetMicrotime($start = 0)
{
	list($msec, $sec) = explode(" ", microtime());
 	return((float)$msec + (float)$sec - (float)$start);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
?>
